<?php
/* POD Documentation

=head1
mp3_radio

Main class for setting up an online mp3 radio.

=head2
License

Copyright (C) 2005 Ondrej Maly <lykantrop@yahoo.co.uk>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or any later version.

This program is distributed in the hope that it will be useful,
but B<WITHOUT ANY WARRANTY>; without even the implied warranty of
B<MERCHANTABILITY> or B<FITNESS FOR A PARTICULAR PURPOSE>.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can found more information about GPL licence at:
http://www.gnu.org/licenses/gpl.html

=head2
Dependencies

=for html
<p>This class depends on <a href='mp3_filelist.html'>mp3_filelist</a> and <a href='mp3_idv.html'>mp3_idv</a>.</p>

=head2
Description

This class provides a simple Internet Radio functionality. There's a queue of mp3 files in the 
specified directory, which are served consecutively by each request. It holds the order of the
files as they are uploaded. The files are deleted from the directory when they are sent. 
In fact, it's more a jukebox than radio :) It supports both Windows 
Media Player and WinAmp (and like), but WinAmp is more reccomended because it doesn't cache the 
files. (WMP hangs up on playing just one file again and again sometimes.) The player must be set 
to repeat continuously the 'track' and in case of WMP also to always connect to the Internet 
(I<'Options/Player/Connect to the Internet'>). Then just select I<'File/Open URL'> and type in the Internet 
address of the script.

=head2
Usage

Invoke as frequently as Thou wilt:

=begin html

<p>
<span class="gray">&lt;?php</span><br />
<b>require_once</b> ( "class.mp3_radio.php");
</p>
<p>
$radio = &<b>new</b> mp3_radio();<br />
$radio->play();<br />
<span class="gray">?&gt;</span>
</p>

=end html

That's all.

=cut

*/

require_once ( "class.mp3_filelist.php");

class mp3_radio extends mp3_filelist {

/* POD Documentation

=head2
DOGMA (Constants and Variables)

=head3
(string) mp3_radio::cwd

Path where the script resides

=cut

*/

var
    // cesta, kde sidli skript radia
    $cwd;
    
/* POD Documentation

=head2
RITUAL (Methods)

=cut

*/
/* POD Documentation

=head3
(void) mp3_filelist::mp3_radio()

=for html
<p>Constructor. When called, it performs following actions. Sets the mp3_radio::cwd, erases last
served music file and rebuilds the playlist (see <a href='mp3_filelist.html'>mp3_filelist</a>).</p>

=cut

*/
function mp3_radio () {

    $_a = pathinfo ( $_SERVER[SCRIPT_NAME]);
    $this->cwd = ltrim ( $_a['dirname'], "/\\");

    $this->unlink_last();
    $this->create_raw_filelist();
    $this->create_new_filelist();
}

/* POD Documentation

=head3
(void) mp3_filelist::play()

This is the only public method in this class. It prepares the headers and the content to be sent to 
the client. It behaves slightly differently according to the client application. When the client is 
the Windows Media Player, it sends a link to the file, in other cases it sends the whole file as
desired by WinAmp for example.

=cut

*/
function play () {

    if ( $fd = @fopen ( $this->MP3_LIST, "r")) {
        $fname = rtrim ( fgets ( $fd));
        fclose ( $fd);
        
        ob_start();
        
        // Ve skutecnosti to potrebuje Windows Media Player, ale muze to zustat tu
        header("Pragma: no-cache");
        header("Cache-Control: no-cache, must-revalidate");
        header("Expires: " . date ( 'r'));
        
        // Windows Media Player
        if ( preg_match ( '/Windows-Media-Player/i', $_SERVER['HTTP_USER_AGENT'])) {

            header("Content-Type: audio/mpegurl");
            header("Content-Disposition: filename=\"playlist.m3u\"");
            
            /*
            require_once ( 'class.mp3_idv.php');
            $idv = &new mp3_idv();
            $id3 = get_id3_info ( $this->MP3_DIR . "/" . $fname);
            
            if ( $id3) {
                echo "#EXTM3U" . $this->LB;
                echo "#EXTINF:" . $id3['length'] . "," . $id3['TPE1'] . " - " . $id3['TIT2'] . $this->LB;
            }
            */
            
            echo $this->link_encode("http://" . $_SERVER[HTTP_HOST] . "/" . $this->cwd . "/" . $this->MP3_DIR . "/" . $fname);

        // Winamp ...
        } else {
            header("Content-Type: audio/mp3");
            header("Content-Disposition: filename=\"$fname\"");
            header("Content-Length: " . filesize ( $this->MP3_DIR . "/" . $fname));
            
            if ( $fd = @fopen ( $this->MP3_DIR . "/" . $fname, "rb")) {
                $buf = fread ( $fd, filesize ( $this->MP3_DIR . "/" . $fname));
                fclose ( $fd);
                echo $buf;
            }
        }
        
        if ( $fd = @fopen ( $this->MP3_LAST, "w")) {
            fwrite ( $fd, $fname);
            fclose ( $fd);
        }
        ob_flush();
    }
}

/* POD Documentation

=head3
(void) mp3_filelist::unlink_last()

Erases last served music file.

=cut

*/
function unlink_last () {
    
    if ( $fd = @fopen ( $this->MP3_LAST, "r")) {
        @unlink ( "./" . $this->MP3_DIR . "/" . rtrim ( fgets ( $fd)));
        fclose ( $fd);
        @unlink ( $this->MP3_LAST);
        return true;
    }
}

/* POD Documentation

=head3
(string) mp3_filelist::link_encode (string $p_url)

=begin html

<p>function 'linkencode' by<br />
<a href='mailto:dphantom@ticino.com'>dphantom@ticino.com</a><br />
03-Feb-2002 03:48<br />
found at php.net</p>

=end html

Encodes properly the link to the music file. It takes an absolute URL as an argument.

=cut

*/
function link_encode($p_url){
  $ta = parse_url($p_url);
  if (!empty($ta[scheme])) { $ta[scheme].='://'; }
  if (!empty($ta[pass]) and !empty($ta[user])) {
    $ta[user].=':';
    $ta[pass]=rawurlencode($ta[pass]).'@';
  }elseif(!empty($ta[user])) {
  $ta[user].='@';
  }
  if (!empty($ta[port]) and !empty($ta[host])) {
    $ta[host]=''.$ta[host].':';
  } elseif (!empty($ta[host])) {
  $ta[host]=$ta[host]; 
  }
  if (!empty($ta[path])) {
  $tu='';
  $tok=strtok($ta[path], "\\/");
  while (strlen($tok)) {
    $tu.=rawurlencode($tok).'/';
    $tok=strtok("\\/");
  }
  $ta[path]='/'.trim($tu, '/');
  }
  if (!empty($ta[query])) { $ta[query]='?'.$ta[query]; }
  if (!empty($ta[fragment])) { $ta[fragment]='#'.$ta[fragment]; }
  return implode('', array($ta[scheme], $ta[user], $ta[pass], $ta[host], $ta[port], $ta[path], $ta[query], $ta[fragment]));
}
} // class mp3_radio
?>
