<?php
/* POD Documentation

=head1
mp3_idv

=for html
<p>Class for reading idv tags from mp3 files. It's a helper class for <a href='mp3_radio.html'>mp3_radio</a>.</p>

=cut

*/
class mp3_idv {
/* POD Documentation

=head2
DOGMA (Constants and Variables)

There's nothing like this.

=cut

*/
/* POD Documentation

=head2
RITUAL (Methods)

=cut

*/
/* POD Documentation

=head3
(array) mp3_idv::get_id3_info (string $fname)

Tries to read id3 tags from a file specified in $fname. Returns an associative array of 
('tagname'=>'value') pairs plus ('length'=>(int)), which is used when building 
m3u playlists.

=cut

*/
function get_id3_info ( $fname) {
    
    if ( $fd = fopen ( $fname, "rb")) {
        while ( ( $char = fgetc ( $fd)) != "\xFF") {
            $a_idv[] = $char;
        }
        if ( is_array ($a_idv)) {
            fclose ( $fd);
            $start = (int)array_search ( 'T', $a_idv);
            $a_idv = array_slice ( $a_idv, $start);
    
            while ( $key = implode ( '', array_slice ( $a_idv, 0, 4))) {
                $length = ord($a_idv[7]) - 1;
                $a_out[$key] = $value  = implode ( '', array_slice ( $a_idv, 11, $length));
                $a_idv = array_slice ( $a_idv, 11 + $length);
            }
            if ( $a_out)
                $a_out['length'] = filesize ( $fname) / 16000;
            return $a_out;
        }
    }
}
}
?>
