<?php
/*******************************************************************************
Copyright (C) 2005 Ondrej Maly <lykantrop@yahoo.co.uk>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can found more information about GPL licence at:
http://www.gnu.org/licenses/gpl.html

contact me: lykantrop@yahoo.co.uk
*******************************************************************************/

/* POD Documentation

=head1
mp3_filelist

=for html
<p>This class provides some methods for handling playlists when setting up online radio. 
It's a helper class for <a href='mp3_radio.html'>mp3_radio</a>.</p>

=cut

*/

class mp3_filelist {

/* POD Documentation

=head2
DOGMA (Constants and Variables)

=head3
(string) mp3_filelist::MP3_DIR

The name of the directory, where the music in mp3 format resides.

=head3
(string) mp3_filelist::LB

The format of the line-break. Could be "\r\n" for win32, "\n" for Unix/Linux or "\r" (Mac).

=head3
(string) mp3_filelist::MP3_LIST

The name of the playlist file.

=head3
(string) mp3_filelist::MP3_LAST

The name of the file storing last served filename.

=head3
(array) mp3_filelist::raw_filelist

List of all the files residing in the mp3_filelist::MP3_DIR directory when the request came.

=head3
(array) mp3_filelist::old_filelist

Old filelist

=head3
(array) mp3_filelist::filelist

New filelist. See the description of the mp3_filelist::create_new_filelist method

=cut

*/

var 
    // Nazev adresare s muzikou
    $MP3_DIR  = "mp3",
        
    // Format ukonceni radku
    $LB       = "\r\n",
    //$LB       = "\n",
    //$LB       = "\r",
    
    // Playlist
    $MP3_LIST = "mp3_list.dat",
    
    // Naposledy poslany soubor
    $MP3_LAST = "last.dat",

    // Seznam souboru aktualne se nachazejicich v adresari s muzikou
    $raw_filelist,
    
    // Stary seznam
    $old_filelist,
    
    // Prave platny seznam
    $filelist;
    
/* POD Documentation

=head2
RITUAL (Methods)

=cut

*/
/* POD Documentation

=head3
(void) mp3_filelist::create_raw_filelist()

Creates a list of all music files currently in the mp3_filelist::MP3_DIR directory. Now working
only with the mp3 files.

=cut

*/
function create_raw_filelist() {
    
    if ( ! $dir = @dir ( "./".$this->MP3_DIR))
        return false;
    while ( $fname = $dir->read()) {

        preg_match ("/^(.+)\.(\w+)$/", $fname, $matches);
        list ( $fname, $name, $ext) = $matches;
        if ( in_array ( strtolower ( $ext), array ( "mp3"))) {
            $a_files[] = $fname;
        }
    }
    $dir->close();

    $this->raw_filelist = (array)$a_files;
    if ( is_array ( $a_files))
        return true;
}

/* POD Documentation

=head3
(void) mp3_filelist::create_new_filelist()

Opens old filelist from the mp3_filelist::MP3_LIST file, then compares it to the 
mp3_filelist::raw_filelist. Places the intersection at the beginning and appends 
to its end a list of files added since previous call. This creates FIFO-like
queue of mp3's. Then saves it.

=cut

*/
function create_new_filelist() {
    
    if ( $fd = @fopen ( $this->MP3_LIST, "r")) {
        while ( $row = fgets ( $fd)) {
            $this->old_filelist[] = rtrim ( $row);
        }
        fclose ( $fd);
    }
    
    $_a = array_intersect ( (array)$this->old_filelist, (array)$this->raw_filelist);
    $_b = array_diff ( (array)$this->raw_filelist, $_a);
    $this->filelist = array_merge ( $_a, $_b);
    
    if ( $fd = @fopen ( $this->MP3_LIST, "w")) {
        fwrite ( $fd, implode ( $this->LB, $this->filelist));
        fclose ( $fd);
    }
    
    if ( ! empty ( $this->filelist))
        return true;
}
} // class mp3_filelist
?>
